Option Explicit

' Create shell and file system objects for accessing registry and file operations
Dim objShell, fso, path, DigitalID, scriptPath
Set objShell = CreateObject("WScript.Shell")
Set fso = CreateObject("Scripting.FileSystemObject")

' Get path of current script
scriptPath = fso.GetParentFolderName(WScript.ScriptFullName)

' Registry path to fetch OS installation details
path = "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\"

On Error Resume Next
' Read digital product ID (used later to extract product key)
DigitalID = objShell.RegRead(path & "DigitalProductID")

' Declare variables for system and license info
Dim ProductName, ProductID, BuildLab, EditionID, WinDir, SysRoot, InstallDateRaw, InstallDate, Channel, CurrentUser, ActivationStatus, PKeyPath, OSArch, ComputerName

' Read OS and user-related info from registry/environment
ProductName = objShell.RegRead(path & "ProductName")
ProductID = objShell.RegRead(path & "ProductID")
BuildLab = objShell.RegRead(path & "BuildLabEx")
EditionID = objShell.RegRead(path & "EditionID")
WinDir = objShell.RegRead(path & "PathName")
SysRoot = objShell.RegRead(path & "SystemRoot")
CurrentUser = objShell.ExpandEnvironmentStrings("%USERNAME%")

' Convert registry install date (in Unix timestamp) to human-readable format
InstallDateRaw = objShell.RegRead(path & "InstallDate")
If IsEmpty(InstallDateRaw) Then
    InstallDate = "Unknown"
Else
    Dim ts, dt
    ts = CLng(InstallDateRaw)
    dt = DateAdd("s", ts, "01/01/1970 00:00:00")
    InstallDate = CStr(dt)
End If

' Read product key channel info
ChannelPath = "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SoftwareProtectionPlatform\"
ChannelValue = objShell.RegRead(ChannelPath & "Channel")
If IsEmpty(ChannelValue) Then
    Channel = "Not available"
Else
    Channel = ChannelValue
End If

' Use WMI to get accurate Windows Activation Status
On Error Resume Next
ActivationStatus = GetActivationStatus()
If Err.Number <> 0 Then
    ActivationStatus = "Not available"
    Err.Clear
End If
On Error GoTo 0

' Read Product Key Channel (e.g., Retail, OEM, Volume)
On Error Resume Next
PKeyPath = objShell.RegRead("HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SoftwareProtectionPlatform\ProductKeyChannel")
If Err.Number <> 0 Then
    PKeyPath = "Not available"
    Err.Clear
End If
On Error GoTo 0

' Read system architecture and computer name
OSArch = objShell.ExpandEnvironmentStrings("%PROCESSOR_ARCHITECTURE%")
ComputerName = objShell.ExpandEnvironmentStrings("%COMPUTERNAME%")

' Initialize WMI for system hardware information queries
Dim wmiService, query, cpuInfo, memoryInfo, diskInfo, batteryStatus
Set wmiService = GetObject("winmgmts:\\.\root\cimv2")

' ----------- CPU Info -----------
query = "SELECT * FROM Win32_Processor"
Set cpuInfo = wmiService.ExecQuery(query)
Dim CPUName, CPUSpeed
CPUName = "Unknown"
CPUSpeed = "Unknown"
Dim cpu
For Each cpu In cpuInfo
    CPUName = cpu.Name
    CPUSpeed = cpu.MaxClockSpeed
Next

' ----------- RAM Info -----------
query = "SELECT * FROM Win32_ComputerSystem"
Set memoryInfo = wmiService.ExecQuery(query)
Dim TotalRAM
TotalRAM = "Unknown"
Dim system
For Each system In memoryInfo
    TotalRAM = system.TotalPhysicalMemory / 1024 / 1024 / 1024 ' Convert bytes to GB
Next

' ----------- Disk Space Info -----------
query = "SELECT * FROM Win32_LogicalDisk WHERE DriveType=3"
Set diskInfo = wmiService.ExecQuery(query)
Dim TotalSpace, FreeSpace, DiskName, videoInfo
TotalSpace = "Unknown"
FreeSpace = "Unknown"
DiskName = "Unknown"
Dim disk
For Each disk In diskInfo
    DiskName = disk.DeviceID
    TotalSpace = disk.Size / 1024 / 1024 / 1024
    FreeSpace = disk.FreeSpace / 1024 / 1024 / 1024
Next

' ----------- Graphics Card Info -----------
query = "SELECT * FROM Win32_VideoController"
Set videoInfo = wmiService.ExecQuery(query)
Dim VideoName, VideoMemory
VideoName = "Unknown"
VideoMemory = "Unknown"
Dim video
For Each video In videoInfo
    VideoName = video.Name
    VideoMemory = video.AdapterRAM / 1024 / 1024 ' Convert to MB
Next

' ----------- Battery Info -----------
query = "SELECT * FROM Win32_Battery"
Set batteryStatus = wmiService.ExecQuery(query)
Dim BatteryPercentage, IsCharging
BatteryPercentage = "Unknown"
IsCharging = "Not Available"
Dim battery
If batteryStatus.Count > 0 Then
    For Each battery In batteryStatus
        BatteryPercentage = battery.EstimatedChargeRemaining
        If IsObject(battery) Then
            On Error Resume Next
            IsCharging = battery.Charging
            If Err.Number <> 0 Then
                IsCharging = "Not Available"
                Err.Clear
            End If
            On Error GoTo 0
        End If
    Next
End If

' Check if Digital Product ID was successfully read
If IsEmpty(DigitalID) Then
    MsgBox "Could not read the Windows key from registry. Try running as Administrator.", vbCritical
    WScript.Quit
End If

' Convert binary DigitalProductID to human-readable format
Dim ProductKey
ProductKey = ConvertToKey(DigitalID)

' Display system and license info via GUI
Call ShowUI(ProductName, ProductID, ProductKey, BuildLab, EditionID, WinDir, SysRoot, InstallDate, Channel, CurrentUser, ActivationStatus, PKeyPath, OSArch, ComputerName, CPUName, CPUSpeed, TotalRAM, TotalSpace, FreeSpace, BatteryPercentage, IsCharging, VideoName)

' Decode DigitalProductID to readable Windows key
Function ConvertToKey(Key)
    Const KeyOffset = 52
    Dim isWin8, Maps, i, k, Current, KeyOutput, Last, keypart1, insert
    isWin8 = (Key(66) \ 6) And 1
    Key(66) = (Key(66) And &HF7) Or ((isWin8 And 2) * 4)
    i = 24
    Maps = "BCDFGHJKMPQRTVWXY2346789"
    Do
        Current = 0
        k = 14
        Do
            Current = Current * 256
            Current = Key(k + KeyOffset) + Current
            Key(k + KeyOffset) = (Current \ 24)
            Current = Current Mod 24
            k = k - 1
        Loop While k >= 0
        i = i - 1
        KeyOutput = Mid(Maps, Current + 1, 1) & KeyOutput
        Last = Current
    Loop While i >= 0
    If isWin8 = 1 Then
        keypart1 = Mid(KeyOutput, 2, Last)
        insert = "N"
        KeyOutput = Replace(KeyOutput, keypart1, keypart1 & insert, 2, 1, 0)
        If Last = 0 Then KeyOutput = insert & KeyOutput
    End If
    ConvertToKey = Mid(KeyOutput, 1, 5) & "-" & Mid(KeyOutput, 6, 5) & "-" & Mid(KeyOutput, 11, 5) & "-" & Mid(KeyOutput, 16, 5) & "-" & Mid(KeyOutput, 21, 5)
End Function

' WMI function to fetch activation status
Function GetActivationStatus()
    Dim wmiService, query, result, activationStatus
    Set wmiService = GetObject("winmgmts:\\.\root\cimv2")
    query = "SELECT LicenseStatus FROM SoftwareLicensingService"
    Set result = wmiService.ExecQuery(query)
    
    If result.Count > 0 Then
        For Each obj In result
            If obj.LicenseStatus = 1 Then
                activationStatus = "Activated"
            ElseIf obj.LicenseStatus = 0 Then
                activationStatus = "Not Activated"
            Else
                activationStatus = "Unknown"
            End If
        Next
    Else
        activationStatus = "Not available"
    End If
    GetActivationStatus = activationStatus
End Function

' Show the Windows Information in UI
Sub ShowUI(pname, pid, pkey, build, edition, windir, sysroot, instDate, channel, user, activation, pkeyChannel, osArch, computer, cpuName, cpuSpeed, totalRAM, totalSpace, freeSpace, batteryPercentage, isCharging, videoName)
    Dim html, tempFile, escPath
    escPath = Replace(scriptPath, "\", "\\")

    html = "<html><head><meta http-equiv='X-UA-Compatible' content='IE=8'><title>WinSight</title>" & _
    "<style>" & _ 
    "body, html { margin:0; padding:0; height:100%; font-family:Segoe UI; transition:all .3s ease; }" & _ 
    "body.dark { background:#1e1e1e; color:#eee; }" & _ 
    ".sidebar { position:absolute; top:0; bottom:0; left:0; width:220px; background:#fff; border-right:1px solid #ccc; }" & _ 
    "body.dark .sidebar { background:#111; border-color:#444; }" & _ 
    ".sidebar a { display:block; padding:15px 20px; color:#333; text-decoration:none; font-weight:bold; }" & _ 
    "body.dark .sidebar a { color:#ccc; }" & _ 
    ".sidebar a:hover { background:#f0f0f0; }" & _ 
    "body.dark .sidebar a:hover { background:#222; }" & _ 
    ".content { margin-left:220px; padding:30px; background:#f0f2f5; height:100%; box-sizing:border-box; overflow:auto; }" & _ 
    "body.dark .content { background:#1e1e1e; }" & _ 
    "#toggleTheme { position:fixed; top:10px; right:10px; cursor:pointer; padding:6px 12px; background:#ccc; border-radius:4px; font-size:12px; z-index:1000; }" & _ 
    "#toggleTheme:hover { background:#bbb; }" & _ 
    ".field { margin-bottom:15px; }" & _ 
    ".label { font-weight:bold; color:#555; }" & _ 
    "body.dark .label { color:#aaa; }" & _ 
    ".value { background:#fff; padding:8px 10px; border-radius:4px; border:1px solid #ccc; font-family:Consolas, monospace; }" & _ 
    "body.dark .value { background:#333; color:#0f0; border-color:#555; }" & _ 
    "button { margin-left:10px; background:#0078d4; color:#fff; padding:4px 10px; border:none; border-radius:4px; font-size:12px; cursor:pointer; }" & _ 
    "button:hover { background:#005a9e; }" & _ 
    "</style></head><body>" & _ 
    "<div id='toggleTheme' onclick='toggleDark()'>Toggle Mode</div>" & _ 
    "<div class='sidebar'>" & _ 
    "<a href='#' onclick=""showPage('home')"">Home</a>" & _ 
    "<a href='#' onclick=""showPage('more')"">Windows Infos</a>" & _ 
    "<a href='#' onclick=""showPage('systemInfos')"">System Infos</a>" & _ 
    "<a href='#' onclick=""showPage('save')"">Save</a>" & _ 
    "<a href='#' onclick=""showPage('about')"">About</a>" & _ 
    "</div>" & _ 
    "<div class='content' id='page'></div>" & _ 
    "<script>" & _ 
    "function showPage(page) {" & _ 
    "  var html='';" & _ 
    "  if(page=='home') {" & _ 
    "    html+='<h2>Windows Product Information</h2>';" & _ 
    "    html+='<div class=field><div class=label>Product Name:</div><div class=value>" & pname & " <button onclick=""copyText(&quot;" & pname & "&quot;);"">&#128203;</button></div></div>';" & _  
    "    html+='<div class=field><div class=label>Product ID:</div><div class=value>" & pid & " <button onclick=""copyText(&quot;" & pid & "&quot;);"">&#128203;</button></div></div>';" & _  
    "    html+='<div class=field><div class=label>Installed Key:</div><div class=value>" & pkey & " <button onclick=""copyText(&quot;" & pkey & "&quot;);"">&#128203;</button></div></div>';" & _  
    "    html+='<div class=field><div class=label>Build Version:</div><div class=value>" & build & "</div></div>';" & _ 
    "  } else if(page=='systemInfos') {" & _ 
    "    html+='<h2>System Infos</h2>';" & _ 
    "    html+='<div class=field><div class=label>CPU:</div><div class=value>" & cpuName & " - " & cpuspeed & " MHz</div></div>';" & _ 
    "    html+='<div class=field><div class=label>Total RAM:</div><div class=value>" & totalRAM & " GB</div></div>';" & _ 
    "    html+='<div class=field><div class=label>Disk Space (C:):</div><div class=value>" & TotalSpace & " GB Total, " & FreeSpace & " GB Free</div></div>';" & _ 
    "    html+='<div class=field><div class=label>Graphics Card:</div><div class=value>" & VideoName & "</div></div>';" & _ 
    "    html+='<div class=field><div class=label>Battery Percentage:</div><div class=value>" & batteryPercentage & "%</div></div>';" & _ 
    "  } else if(page=='save') {" & _ 
    "    html+='<h2>Save to File</h2><p>Click to save your key info:</p>';" & _ 
    "    html+='<button onclick=""saveAsTXT()"">Save as TXT</button>';" & _
    "    html+='<button onclick=""saveAsJSON()"">Save as JSON</button>';" & _
    "  } else if(page=='more') {" & _
    "    html+='<h2>More System Details</h2>';" & _
    "    html+='<div class=field><div class=label>Current User:</div><div class=value>" & user & "</div></div>';" & _
    "    html+='<div class=field><div class=label>Edition ID:</div><div class=value>" & edition & "</div></div>';" & _
    "    html+='<div class=field><div class=label>Install Date:</div><div class=value>" & instDate & "</div></div>';" & _
    "    html+='<div class=field><div class=label>License Channel:</div><div class=value>" & channel & "</div></div>';" & _
    "    html+='<div class=field><div class=label>Windows Directory:</div><div class=value>" & windir & "</div></div>';" & _
    "    html+='<div class=field><div class=label>System Root:</div><div class=value>" & sysroot & "</div></div>';" & _
    "  } else if(page=='about') {" & _ 
    "    html+='<h2>About</h2>';" & _ 
    "    html+='<p>Created by <b>Saltyy</b></p>';" & _ 
    "    html+='<p><a href=# onclick=""openExternal(&quot;https://gitlab.com/Saltyy&quot;)"">GitLab</a></p>';" & _ 
    "    html+='<p><a href=# onclick=""openExternal(&quot;https://gitlab.com/Saltyy/WinSight&quot;)"">Code</a></p>';" & _ 
    "    html+='<p><a href=# onclick=""openExternal(&quot;https://www.saltyy.at&quot;)"">Website</a></p>';" & _
    "  }" & _
    "  document.getElementById('page').innerHTML = html;" & _ 
    "}" & _ 
    "function toggleDark() {" & _ 
    "  var b = document.body;" & _ 
    "  if(b.className.indexOf('dark')==-1){ b.className += ' dark'; }" & _ 
    "  else{ b.className = b.className.replace('dark',''); }" & _ 
    "}" & _ 
    "function copyText(text) {" & _ 
    "  var dummy = document.createElement('textarea');" & _ 
    "  dummy.value = text;" & _ 
    "  document.body.appendChild(dummy);" & _ 
    "  dummy.select();" & _ 
    "  document.execCommand('copy');" & _ 
    "  document.body.removeChild(dummy);" & _ 
    "  alert('Copied to clipboard: ' + text);" & _ 
    "}" & _ 
    "function saveAsTXT() {" & _ 
    "  var fso = new ActiveXObject('Scripting.FileSystemObject');" & _ 
    "  var file = fso.CreateTextFile('" & escPath & "\\\\WindowsInfo.txt', true);" & _ 
    "  file.WriteLine('Product Name: " & pname & "');" & _ 
    "  file.WriteLine('Installed Key: " & pkey & "');" & _ 
    "  file.WriteLine('Current User: " & user & "');" & _ 
    "  file.WriteLine('Computer Name: " & computer & "');" & _ 
    "  file.WriteLine('Install Date: " & instDate & "');" & _ 
    "  file.WriteLine('Windows Directory: " & windir & "');" & _ 
    "  file.WriteLine('System Root: " & sysroot & "');" & _ 
    "  file.Close();" & _ 
    "  alert('Saved to: " & escPath & "\\WindowsInfo.txt');" & _ 
    "}" & _ 
    "function openExternal(url) {" & _
    "  var shell = new ActiveXObject('WScript.Shell');" & _
    "  shell.Run(url);" & _
    "}" & _
    "function saveAsJSON() {" & _
    "  var data = {" & _
    "    'ProductName': '" & pname & "'," & _
    "    'ProductKey': '" & pkey & "'," & _
    "    'CurrentUser': '" & user & "'," & _
    "    'ComputerName': '" & computer & "'," & _
    "    'InstallDate': '" & instDate & "'," & _
    "    'WindowsDirectory': '" & windir & "'," & _
    "    'SystemRoot': '" & sysroot & "'," & _
    "    'OSArchitecture': '" & osArch & "'," & _
    "    'BuildVersion': '" & build & "'," & _
    "    'ActivationStatus': '" & activation & "'," & _
    "    'LicenseChannel': '" & channel & "'," & _
    "    'ProductKeyChannel': '" & pkeyChannel & "'" & _
    "  };" & _
    "  var jsonText = JSON.stringify(data, null, 2);" & _
    "  try {" & _
    "    var fso = new ActiveXObject('Scripting.FileSystemObject');" & _
    "    var file = fso.CreateTextFile('" & escPath & "\\\\WindowsInfo.json', true);" & _
    "    file.Write(jsonText);" & _
    "    file.Close();" & _
    "    alert('JSON export saved to: " & escPath & "\\\\WindowsInfo.json');" & _
    "  } catch (e) {" & _
    "    alert('Failed to save JSON: ' + e.message);" & _
    "  }" & _
    "};" & _
    "showPage('home');" & _
    "</script></body></html>"

    tempFile = scriptPath & "\WindowsInfo.html"
    With fso.CreateTextFile(tempFile, True)
        .Write html
        .Close
    End With

    objShell.Run "mshta.exe """ & tempFile & """", 1, False
End Sub